<?php

class EntidadeModel extends Database
{

	protected function insertEntidade($idUsuario, $idTipoEntidade, $nome, $nomeComercial, $bi, $nif, $localidade, $dataNasc, $morada, $linhaPreco, $retencaoFonte, $estado)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO entidade (idUsuario, idTipoEntidade, nome, nomeComercial, bi, nif, localidade, dataNasc, morada, linhaPreco, retencaoFonte, estado) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario, $idTipoEntidade, $nome, $nomeComercial, $bi, $nif, $localidade, $dataNasc, $morada, $linhaPreco, $retencaoFonte, $estado)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editEntidade($idEntidade, $idUsuario, $idTipoEntidade, $nome, $nomeComercial, $bi, $nif, $localidade, $dataNasc, $morada, $linhaPreco, $retencaoFonte, $estado)
	{
		$sql = "UPDATE entidade SET idUsuario = ?, idTipoEntidade = ?, nome = ?, nomeComercial = ?, bi = ?, nif = ?, localidade = ?, dataNasc = ?, morada = ?, linhaPreco = ?, retencaoFonte = ?, estado = ? WHERE idEntidade = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute(array($idUsuario, $idTipoEntidade, $nome, $nomeComercial, $bi, $nif, $localidade, $dataNasc, $morada, $linhaPreco, $retencaoFonte, $estado, $idEntidade))) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	public function parentEntidade()
	{
		$data = null;
		$sql = "SELECT * FROM Entidade";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoEntidade()
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(idEntidade), 0) + 1 AS contador FROM entidade";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryEntidade($idEntidade)
	{
		$data = null;
		$sql = "SELECT * FROM viewEntidade WHERE idEntidade = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idEntidade]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function funcaoQueryEntidade($idEntidade, $idTipoEntidade)
	{
		$data = null;
		$sql = "SELECT * FROM viewEntidade WHERE idTipoEntidade = ? AND idEntidade = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idTipoEntidade, $idEntidade]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemCliente($tipoEntidade)
	{
		$data = null;
		$sql = "SELECT * FROM viewEntidade WHERE idTipoEntidade = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$tipoEntidade]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemEntidade($tipoEntidade)
	{
	    
		$data = null;
		$sql = "SELECT * FROM viewEntidade";
		if($tipoEntidade != null){
			$sql .= " WHERE idTipoEntidade = ?";
			if ($stmt = $this->connect()->prepare($sql)) {
			  $stmt->execute([$tipoEntidade]);
			  while ($row = $stmt->fetch()) {
				$data[] = $row;
		    	}
		}
		}else{
		    if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute();
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		  }
		}
		
		return $data;
	}

	public function deleteEntidade($idEntidade)
	{
		$sql = "DELETE FROM entidade WHERE idEntidade = ?";
		$img = $this->fotoPerfilEntidade($idEntidade);
		if ($img[0]["imagem"] != null) {
			$nameImg = "../../images/entidade/" . $img[0]["imagem"];
			$file = $nameImg;
			unlink($file);
		}
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute([$idEntidade])) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	private function fotoPerfilEntidade($idEntidade)
	{
		$data = null;
		$sql = "SELECT * FROM entidade WHERE idEntidade = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idEntidade]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function selectEntidade()
	{
		$sql = "SELECT * FROM Entidade";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<option name="idEntidade" value="' . $row['idEntidade'] . '">' . $row['nome'] . '</option>'; //'<option value='"$row['idEntidade']"'>'"$row['nome']"'</option>';
			//echo $row['idUsuario'];
			//echo $row['nome'];
		}
	}

	protected function listaEntidade()
	{
		$sql = "SELECT * FROM Entidade";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<tr>
					<td>' . $row['idEntidade'] . '</td>
					<td>' . $row['nome'] . '</td>
					<td>
						<a href="../includes/EntidadeUpdate.inc.php?id=' . $row['idEntidade'] . '" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/EntidadeDelete.inc.php?id=' . $row['idEntidade'] . '"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
		}
	}

	public function autoIncrementEntidade()
	{
		$sql = "SELECT `AUTO_INCREMENT`
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'entidade';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['AUTO_INCREMENT'];
	}
}
