<?php

class FamiliaModel extends Database
{

	protected function insertFamilia($idUsuario, $nome, $nota)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO familia (idUsuario, nome, nota) VALUES (?, ?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idUsuario, $nome, $nota)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function editFamilia($idFamilia, $idUsuario, $nome, $nota)
	{
		$sql = "UPDATE familia SET nome = ?, nota = ? WHERE idFamilia = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute(array($nome, $nota, $idFamilia))) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	public function parentFamilia()
	{
		$data = null;
		$sql = "SELECT * FROM familia";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readFamilia()
	{
		$data = null;
		$sql = "SELECT * FROM familia";
		$this->connect()->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		if ($stmt = $this->connect()->query($sql)) {
		    $data = $stmt->fetchAll();
		    $data = empty($data) ? 1 : $data;
		    return $data;
		} else {
		    $data =  $this->connect()->errorInfo();
		}
		return $data;
	}

	public function deleteFamilia($idFamilia)
	{
		$sql = "DELETE FROM familia WHERE idFamilia = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute([$idFamilia])) {
			$stmt = null;
			header("location: ../familiaLista.php?Erro=Eliminar!");
			exit();
		}
		$stmt = null;
	}

	protected function selectFamilia()
	{
		$sql = "SELECT * FROM familia";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<option name="idFamilia" value="' . $row['idFamilia'] . '">' . $row['nome'] . '</option>'; //'<option value='"$row['idFamilia']"'>'"$row['nome']"'</option>';
			//echo $row['idUsuario'];
			//echo $row['nome'];
		}
	}

	protected function listaFamilia()
	{
		$sql = "SELECT * FROM familia";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<tr>
					<td>' . $row['idFamilia'] . '</td>
					<td>' . $row['nome'] . '</td>
					<td>
						<a href="../includes/familiaUpdate.inc.php?id=' . $row['idFamilia'] . '" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/familiaDelete.inc.php?id=' . $row['idFamilia'] . '"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
		}
	}

	public function queryFamilia($idFamilia)
	{
		$data = null;
		$sql = "SELECT * FROM viewfamiliausuario WHERE idFamilia = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idFamilia]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function countFamilia()
	{
		$sql = "SELECT COUNT(*) FROM familia";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		echo $results['COUNT(*)'];
	}

	public function autoIncrementFamilia()
	{
		$sql = "SELECT `AUTO_INCREMENT` AS contador
			FROM INFORMATION_SCHEMA.TABLES
			WHERE TABLE_SCHEMA = 'test1234'
			AND TABLE_NAME = 'familia';";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		return $results['contador'];
	}
}
