<?php
    class ModoPagamentoDocumentoModel extends Database {

		protected function insertModoPagamentoDocumento($idModoPagamento, $idDocumento, $valor){
            $stmt = $this->connect();
            $sql = "INSERT INTO modopagamentodocumento (idModoPagamento, idDocumento, valor) VALUES (?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idModoPagamento, $idDocumento, $valor)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemModoPagamentoDocumento(){
			$data = null;
			$sql = "SELECT * FROM modopagamentodocumento";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryModoPagamentoDocumento($idModoPagamentoDocumento){
			$data = null;
			$sql = "SELECT * FROM modopagamentodocumento WHERE idModoPagamentoDocumento = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idModoPagamentoDocumento]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function editModoPagamentoDocumento($idModoPagamentoDocumento, $idModoPagamento, $idDocumento, $valor){
			$stmt = $this->connect();
			
            $sql = "UPDATE modopagamentodocumento SET idModoPagamento = ?, idDocumento = ?, valor = ? WHERE idModoPagamentoDocumento = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idModoPagamento, $idDocumento, $valor, $idModoPagamentoDocumento)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function deleteModoPagamentoDocumento($idModoPagamentoDocumento){
			$stmt = $this->connect();
            $sql = "DELETE FROM modopagamentodocumento WHERE idModoPagamentoDocumento = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idModoPagamentoDocumento)))){
				$query = null;
				exit();
			}
		}
    }