<?php

class PaisModel extends Database {

	protected function insertPais($codigo, $designacao, $codigoIso, $descricao){
		$stmt = $this->connect();
		$sql = "INSERT INTO pais (codigo, designacao, codigoIso, descricao) VALUES (?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if(!($query->execute(array($codigo, $designacao, $codigoIso, $descricao)))){
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

		protected function editPais($idPais, $codigo, $designacao, $codigoIso, $descricao){
			$sql = "UPDATE pais SET codigo = ?, designacao = ?, codigoIso = ?, descricao = ? WHERE idPais = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute(array($codigo, $designacao, $codigoIso, $descricao, $idPais))){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}
		
		public function parentPais(){
			$data = null;
			$sql = "SELECT * FROM pais";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function readCodigoPais(){
			$data = null;
			$sql = "SELECT COALESCE(MAX(idPais), 0) + 1 AS contador FROM pais";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryPais($idPais){
			$data = null;
			$sql = "SELECT * FROM pais WHERE idPais = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idPais]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemPais(){
			$data = null;
			$sql = "SELECT * FROM pais";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deletePais($idPais){
			$sql = "DELETE FROM pais WHERE idPais = ?";
			$stmt = $this->connect()->prepare($sql);
			if(!$stmt->execute([$idPais])){
				$stmt = null;
				exit();
			}
			$stmt = null;
		}

		protected function selectPais(){
			$sql = "SELECT * FROM pais";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<option name="idPais" value="'.$row['idPais'].'">' . $row['nome'] . '</option>';//'<option value='"$row['idPais']"'>'"$row['nome']"'</option>';
				//echo $row['idUsuario'];
				//echo $row['nome'];
			}

		}

		protected function listaPais(){
			$sql = "SELECT * FROM pais";
			$stmt = $this->connect()->query($sql);
			while($row = $stmt->fetch()){

				echo '<tr>
					<td>'.$row['idPais'].'</td>
					<td>'.$row['nome'].'</td>
					<td>
						<a href="../includes/PaisUpdate.inc.php?id='.$row['idPais'].'" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/PaisDelete.inc.php?id='.$row['idPais'].'"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
			}

		}

		protected function countPais(){
			$sql = "SELECT COUNT(*) FROM pais";
			$stmt = $this->connect()->query($sql);
			$results = $stmt->fetch();
			echo $results['COUNT(*)'];
		}
	}