<?php

class PrecoArtigoModel extends Database
{

	protected function insertPrecoArtigo($idArtigo, $semImposto, $comImposto, $margem, $indice)
	{
		$stmt = $this->connect();
		$sql = "INSERT INTO precoArtigo (idArtigo, semImposto, comImposto, margem, indice) VALUES (?, ?, ?, ?, ?)";
		$query = $stmt->prepare($sql);
		if (!($query->execute(array($idArtigo, $semImposto, $comImposto, $margem, $indice)))) {
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	public function parentPrecoArtigo()
	{
		$data = null;
		$sql = "SELECT * FROM precoArtigo";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function readCodigoPrecoArtigo()
	{
		$data = null;
		$sql = "SELECT COALESCE(MAX(idPrecoArtigo), 0) + 1 AS contador FROM precoArtigo";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryPrecoArtigo($idPrecoArtigo)
	{
		$data = null;
		$sql = "SELECT * FROM precoArtigo WHERE idPrecoArtigo = ?";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idPrecoArtigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryPreco($idArtigo)
	{
		$data = null;
		$sql = "SELECT * FROM precoArtigo WHERE idArtigo = ? ORDER BY indice";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArtigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function queryPrecoPredefinido($idArtigo)
	{
		$data = null;
		$sql = "SELECT * FROM precoArtigo WHERE idArtigo = ? AND indice = (SELECT valor FROM definicao WHERE idDefinicao = 2)";
		if ($stmt = $this->connect()->prepare($sql)) {
			$stmt->execute([$idArtigo]);
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function listagemPrecoArtigo()
	{
		$data = null;
		$sql = "SELECT * FROM precoArtigo";
		if ($stmt = $this->connect()->query($sql)) {
			while ($row = $stmt->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	public function deletePrecoArtigo($idArtigo)
	{
		$sql = "DELETE FROM precoArtigo WHERE idArtigo = ?";
		$stmt = $this->connect()->prepare($sql);
		if (!$stmt->execute([$idArtigo])) {
			$stmt = null;
			exit();
		}
		$stmt = null;
	}

	protected function selectPrecoArtigo()
	{
		$sql = "SELECT * FROM precoArtigo";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<option name="idPrecoArtigo" value="' . $row['idPrecoArtigo'] . '">' . $row['nome'] . '</option>'; //'<option value='"$row['idPrecoArtigo']"'>'"$row['nome']"'</option>';
			//echo $row['idUsuario'];
			//echo $row['nome'];
		}
	}

	protected function listaPrecoArtigo()
	{
		$sql = "SELECT * FROM precoArtigo";
		$stmt = $this->connect()->query($sql);
		while ($row = $stmt->fetch()) {

			echo '<tr>
					<td>' . $row['idPrecoArtigo'] . '</td>
					<td>' . $row['nome'] . '</td>
					<td>
						<a href="../includes/PrecoArtigoUpdate.inc.php?id=' . $row['idPrecoArtigo'] . '" data-toggle="modal" data-target="#modal-default"><i class="fa-solid fa-pen-to-square"></i></a>
						<a href="../includes/PrecoArtigoDelete.inc.php?id=' . $row['idPrecoArtigo'] . '"><i class="fa-solid fa-trash-can"></i></a>
					</td>
				</tr>';
		}
	}

	protected function countPrecoArtigo()
	{
		$sql = "SELECT COUNT(*) FROM precoArtigo";
		$stmt = $this->connect()->query($sql);
		$results = $stmt->fetch();
		echo $results['COUNT(*)'];
	}
}
