<?php

header("Access-Control-Allow-Origin: *");

include('../class/database.class.php');
include('../class/model.class.php');
include('../class/controller.class.php');

$dados = file_get_contents("php://input");
$dados = json_decode($dados, true);

// echo json_encode($dados);exit;

if ($dados != null && $_SERVER["REQUEST_METHOD"] == "POST") {

    $tabela = $dados['tabela'];
    $fxInsert = $dados['dataInsert'] ?? null;
    $fxUpdate = $dados['dataUpdate'] ?? null;

    $modelo = new Controller();

    if ($fxUpdate != null) {
        $result = $modelo->updateController($tabela, $fxUpdate['data'] ?? [], [$fxUpdate['parameterId']]);
        echo json_encode($result);
        exit;
    } elseif ($fxInsert != null) {
        $result = $modelo->insertController($tabela, $fxInsert);
        echo json_encode($result);
        exit;
    } else {
        $join = $dados['join'] ?? [];
        $sqlJoin = "";
        $sqlWhere = "";
        $sqlFields = "";
        $fields = $dados['coluna'] ?? '*';

        foreach ($join as $obj) {
            $sqlJoin .= $obj['tipo'] . " join " . $obj['tabela'] . " on " . $obj['juncao'] . ' ';
        }
        $params = $dados['parametroId'] ?? null;
        
        $bindParams = [];
        if ($params != null) {
            $sqlWhere = "where " . $params['tabela'] . "." . $params['parametro'] . " = ?";
        }

        if ($fields != "*") {
            foreach ($fields[0] as $key => $value) {
                $sqlFields .=  "$value as $key, ";
            }
        } else { $sqlFields .= $fields; }

        $sqlFields = rtrim($sqlFields, ", ");
        $sqlJoin = rtrim($sqlJoin, " ");
        $sql = "select $sqlFields from $tabela $sqlJoin $sqlWhere";
        $modelo = new Controller();
        $valorBinding = $params["valor"] ?? -1;
        $result = $modelo->build($sql, $valorBinding != -1 ? [$valorBinding] : []);
        echo json_encode($result);
        exit;
    }
} else if (isset($_POST['chave_api_ge_pos']) && !(empty($_POST['chave_api_ge_pos']))) {
    $chave_api_ge_pos = $_POST['chave_api_ge_pos'];
    if ($chave_api_ge_pos == '$#&!#API_key_POS&_GE_MA#2022') {
        $acao = $_POST['acao'];
        if ($acao == 'insert') {
            $tabela = $_POST["tabela"];
            $dados = $_POST["dados"];

            $modelo = new Controller();
            $result = $modelo->insertController($tabela, $dados);
            echo json_encode($result);
        } elseif ($acao == 'select') {
            $tabela = $_POST["tabela"];
            $modelo = new Controller();
            $result = $modelo->selectController($tabela);
            echo json_encode($result);
        } elseif ($acao == 'select_id') {
            $id = $_POST["id"];
            $tabela = $_POST["tabela"];

            $modelo = new Controller();
            $result = $modelo->querySelectController($tabela, $id);
            echo json_encode($result);
        } elseif ($acao == 'delete') {
            $id = $_POST["id"];
            $tabela = $_POST["tabela"];

            $modelo = new Controller();
            $result = $modelo->deleteController($tabela, $id);
            echo json_encode($result);
        } elseif ($acao == 'querySelect') {
            $data = json_decode($_POST["data"]);
        }
    } else {
        echo json_encode(
            [
                'status' => 401,
                'message' => 'UNAUTHORIZED'
            ]
        );
    }
} else {
    echo json_encode(
        [
            'status' => 401,
            'message' => 'UNAUTHORIZED'
        ]
    );
}