const qtdLinhaPreco = document.getElementById("qtdLinhaPreco");
const linhaPrecoPredefinida = document.getElementById("linhaPrecoPredefinida");
const btn = document.getElementById("btn-submit");

let numberRegExp = new RegExp('^[0-9-() ]+$');
let letterRegExp = new RegExp('^[a-zA-Z ]+$');
let biRegExp = new RegExp('^[a-zA-Z0-9]+$');
let emailRegExp = new RegExp('^[A-Za-z0-9._-]{3,}@[A-Za-z]{3,}[.]{1}[A-Za-z.]{2,6}$');

function qtdLinhaPrecoWarning(small) {
	qtdLinhaPreco.className = "form-control is-warning";
	small.style.visibility = "visible";
	small.style.color = "#ffc107";
	small.innerText = "Campo Qtd. Linha Preço é Obrigatório!";
	btn.setAttribute('disabled', 'disabled');
}

function qtdLinhaPrecoInvalid(small) {
	qtdLinhaPreco.className = "form-control is-invalid";
	small.style.visibility = "visible";
	small.style.color = "#dc3545";
	small.innerText = "Campo Qtd. Linha Preço não pode ser menor que a Linha de Preço pré-definida!";
	btn.setAttribute('disabled', 'disabled');
}

function qtdLinhaPrecoValid(small) {
	qtdLinhaPreco.className = "form-control is-valid";
	btn.removeAttribute('disabled');
	small.style.visibility = "hidden";
}

qtdLinhaPreco.addEventListener("keyup", function () {
	let smallLinhaPrecoPredefinida = linhaPrecoPredefinida.parentElement.querySelectorAll("small")[1];
	let smallQtdLinhaPreco = qtdLinhaPreco.parentElement.querySelectorAll("small")[1];
	if (qtdLinhaPreco.value === '') {
		qtdLinhaPrecoWarning(smallQtdLinhaPreco);
	} else {
		if ($("#linhaPrecoPredefinida").val() > $("#qtdLinhaPreco").val()) {
			linhaPrecoPredefinidaInvalid(smallLinhaPrecoPredefinida);
			qtdLinhaPrecoInvalid(smallQtdLinhaPreco);
		} else {
			linhaPrecoPredefinidaValid(smallLinhaPrecoPredefinida);
			qtdLinhaPrecoValid(smallQtdLinhaPreco);
		}
	}
});

function linhaPrecoPredefinidaInvalid(small) {
	linhaPrecoPredefinida.classList.add("select2-danger");
	linhaPrecoPredefinida.setAttribute('data-dropdown-css-class', 'select2-danger');
	small.style.visibility = "visible";
	small.style.color = "#dc3545";
	small.innerText = "Campo Linha de Preço pré-definida não pode ser maior que a Qtd. Linha Preço!";
	btn.setAttribute('disabled', 'disabled');
}

function linhaPrecoPredefinidaValid(small) {
	linhaPrecoPredefinida.classList.remove("select2-danger");
	linhaPrecoPredefinida.classList.add("is-valid");
	linhaPrecoPredefinida.style.borderColor = "#ffc107";
	btn.removeAttribute('disabled');
	small.style.visibility = "hidden";
}

$('#linhaPrecoPredefinida').select2().on('change', function () {
	let smallLinhaPrecoPredefinida = linhaPrecoPredefinida.parentElement.querySelectorAll("small")[1];
	let smallQtdLinhaPreco = qtdLinhaPreco.parentElement.querySelectorAll("small")[1];
	if ($("#linhaPrecoPredefinida").val() > $("#qtdLinhaPreco").val()) {
		linhaPrecoPredefinidaInvalid(smallLinhaPrecoPredefinida);
		qtdLinhaPrecoInvalid(smallQtdLinhaPreco);
	} else {
		linhaPrecoPredefinidaValid(smallLinhaPrecoPredefinida);
		qtdLinhaPrecoValid(smallQtdLinhaPreco);
	}
});

btn.addEventListener("click", function () {
	let smallQtdLinhaPreco = qtdLinhaPreco.parentElement.querySelectorAll("small")[1];
	if (qtdLinhaPreco.value == '') {
		qtdLinhaPrecoWarning(smallQtdLinhaPreco);
	} else {
		qtdLinhaPrecoValid(smallQtdLinhaPreco);
	}
});