const nome = document.getElementById("nome");
const nomeCurto = document.getElementById("nomeCurto");
const idFamilia = document.getElementById("idFamilia");
const codigoBarra = document.getElementById("codigoBarra");
const tipoServico = document.getElementById("tipoServico");
const idTaxa = document.getElementById("idTaxa");

const slidePage = document.querySelector(".slidePage");
const firstNextBtn = document.querySelector(".nextBtn");
const prevBtnSec = document.querySelector(".prev-1");
const submitBtn = document.querySelector(".submit");
const progressText = document.querySelectorAll(".step p");
const progressCheck = document.querySelectorAll(".step .check");
const bullet = document.querySelectorAll(".step .bullet");

let numberRegExp = new RegExp('^[0-9-()-+ ]+$');
let letterRegExp = new RegExp('^[a-zA-Z ]+$');
let biRegExp = new RegExp('^[a-zA-Z0-9]+$');
let emailRegExp = new RegExp('^[A-Za-z0-9._-]{3,}@[A-Za-z._-]{3,}[.]{1}[A-Za-z.]{2,6}$');

let max = 2;
let current = 1;

function nomeWarning(small) {
    nome.className = "form-control is-warning";
    small.style.visibility = "visible";
    small.style.color = "#ffc107";
    small.innerText = "Campo Nome é obrigatório!";
    firstNextBtn.setAttribute('disabled', 'disabled');
}

function nomeValid(small) {
    nome.className = "form-control is-valid";
    firstNextBtn.removeAttribute('disabled');
    small.style.visibility = "hidden";
}

nome.addEventListener("keyup", function () {
    let small = nome.parentElement.querySelectorAll("small")[1];
    if (nome.value === '') {
        nomeWarning(small);
    } else {
        nomeValid(small);
    }
});

function idFamiliaInvalid(small) {
    idFamilia.classList.add("select2-danger");
    idFamilia.setAttribute('data-dropdown-css-class', 'select2-danger');
    small.style.visibility = "visible";
    small.style.color = "#dc3545";
    small.innerText = "Selecione a família!";
    firstNextBtn.setAttribute('disabled', 'disabled');
}

function idFamiliaValid(small) {
    idFamilia.classList.remove("select2-danger");
    idFamilia.classList.add("is-valid");
    idFamilia.style.borderColor = "#ffc107";
    firstNextBtn.removeAttribute('disabled');
    small.style.visibility = "hidden";
}

$('#idFamilia').select2().on('change', function () {
    let small = idFamilia.parentElement.querySelectorAll("small")[1];
    if ($("#idFamilia").val() == 0) {
        idFamiliaInvalid(small);
    } else {
        idFamiliaValid(small);
    }
});

firstNextBtn.addEventListener("click", function (e) {
    e.preventDefault();
    let smallNome = nome.parentElement.querySelectorAll("small")[1];
    let smallIdFamilia = idFamilia.parentElement.querySelectorAll("small")[1];
    if (nome.value != '' && idFamilia.value != 0) {
        slidePage.style.marginLeft = "-25%";
        bullet[current - 1].classList.add("active");
        progressText[current - 1].classList.add("active");
        progressCheck[current - 1].classList.add("active");
        current += 1;
    } else {
        if (nome.value == '') {
            nomeWarning(smallNome);
        } else {
            nomeValid(smallNome);
        }

        if ($("#idFamilia").val() == 0) {
            idFamiliaInvalid(smallIdFamilia);
        } else {
            idFamiliaValid(smallIdFamilia);
        }
    }
});


submitBtn.addEventListener("click", function (e) {
    e.preventDefault();
    bullet[current - 1].classList.add("active");
    progressText[current - 1].classList.add("active");
    progressCheck[current - 1].classList.add("active");
    current += 1;
    let img = $("#file")[0].files;
    artigo(img);
});

prevBtnSec.addEventListener("click", function (e) {
    e.preventDefault();
    slidePage.style.marginLeft = "0%";
    bullet[current - 2].classList.remove("active");
    progressText[current - 2].classList.remove("active");
    progressCheck[current - 2].classList.remove("active");
    current -= 1;
});

function prazoPagamentoInvalid(small) {
    prazoPagamento.classList.add("select2-danger");
    prazoPagamento.setAttribute('data-dropdown-css-class', 'select2-danger');
    small.style.visibility = "visible";
    small.style.color = "#dc3545";
    small.innerText = "Selecione um Prazo de Pagamento!";
    firstNextBtn.setAttribute('disabled', 'disabled');
}

function prazoPagamentoValid(small) {
    prazoPagamento.classList.remove("select2-danger");
    prazoPagamento.classList.add("is-valid");
    prazoPagamento.style.borderColor = "#ffc107";
    firstNextBtn.removeAttribute('disabled');
    small.style.visibility = "hidden";
}

$('#prazoPagamento').select2().on('change', function () {
    let small = prazoPagamento.parentElement.querySelectorAll("small")[1];
    if ($("#prazoPagamento").val() == 0) {
        prazoPagamentoInvalid(small);
    } else {
        prazoPagamentoValid(small);
    }
});

function resetForm(){
    slidePage.style.marginLeft = "0%";
    for (let i = 0; i < progressText.length; i++) {
        bullet[i].classList.remove("active");
        progressText[i].classList.remove("active");
        progressCheck[i].classList.remove("active");
    }
    current = 1;
}